script = [f"{CTv_PUBKEY} OP_CHECKSIGVERIFY"]

vector_count = SEED_VECTORS
fib_index = 0

for fold_index, fold_size in enumerate(FOLD_DOUBLINGS):
    vector_count *= 2

    # Logarithmic folding
    script.append(f"OP_VEC_DUP {vector_count//2} OP_HDGL_VEC_ADD OP_EQUALVERIFY")

    # Parameter folding with Fibonacci delta
    fib_delta = FIBS[fib_index % len(FIBS)]
    fib_index += 1

    param = SEED_PARAMS[fold_index % len(SEED_PARAMS)]
    omega_int = int(param[1], 16)
    omega_min = omega_int + fib_delta
    omega_max = omega_int + fib_delta

    script.append(f"{vector_count//2} {vector_count//2} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")
    script.append(f"{omega_int} {omega_min} {omega_max} OP_WITHINVERIFY")
    script.append("")  # newline for readability

script.append("OP_CHECKTEMPLATEVERIFY")
